<!DOCTYPE html>
<html lang="en">

<head>
  <style>
    .required:after {
      content: " *";
      color: red;
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Edit Task</title>

  <?php
    include 'header.php';
    include 'navbar.php';
    ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Task Add</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Edit Task</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" name="editTaskForm">
            <div class="row">
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">General</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <?php 
                            $task_id = $_POST["task_id"];
                            $query1 = $db->query("SELECT * FROM tasks WHERE id ='".$task_id."'");
                            if($query1 !== false && $query1->num_rows > 0){
                                while($row = $query1->fetch_assoc()){
                                $task_name = $row["task_name"];
                                $task_desc = $row["task_desc"];
                                $task_unit_id = $row["unit_id"];
                                $task_price = $row["price"]; ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="taskName" class="required">Task Name</label>
                                <input type="text" id="taskName" name="taskName" class="form-control" value="<?php echo $task_name; ?>">
                                <input type="text" id="task_id" name="task_id" class="form-control" value="<?php echo $task_id; ?>" hidden>
                            </div>
                            <div class="form-group">
                                <label for="taskDescription">Task Description</label>
                                <textarea id="taskDescription" name="taskDescription" class="form-control" rows="4"><?php echo $task_desc; ?></textarea>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-md-6">
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">Details</h3>
                            <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="inputTaskUnit" class="required">Unit Type</label>
                                <select id="taskUnit" name="taskUnit" class="form-control custom-select">
                                    <!-- Old Selected Unit-->
                                    <option value='<?php echo $task_unit_id; ?>'>
                                    <?php 
                                        $unit_name = '';
                                        $query2 = $db->query("SELECT unit_name FROM units WHERE id ='".$task_unit_id."'");
                                        if($query2->num_rows > 0){
                                            while($row = $query2->fetch_assoc()){
                                            $unit_name = $row["unit_name"];
                                            echo $unit_name;}};
                                        ?>
                                    </option>
                                    <?php
                                    $query = $db->query("SELECT * FROM units ORDER BY id ASC");
                                    if($query->num_rows > 0){
                                    while($row = $query->fetch_assoc()){
                                        $unit_name = $row["unit_name"];
                                        $unit_id = $row["id"];
                                        echo '<option value="'.$unit_id.'">'.$unit_name.'</option>';
                                        }
                                        };
                                    }};
                                    //$db->close();
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="price" class="required">Price</label>
                                <input type="number" id="price" name="price" class="form-control" value='<?php echo $task_price; ?>'>
                            </div>
                        </div><!-- /.card-body -->
                    </div><!-- /.card -->
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <a href="tasks.php" class="btn btn-secondary">Back to All Tasks</a>
                    <input type="submit" name="submiedit" value="Update Task" class="btn btn-success float-right">
                </div>
            </div>
            <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
            <?php
                if(isset($_POST["submiedit"])) {    
                    $task_name = $_POST['taskName'];
                    $task_desc = $_POST['taskDescription'];
                    $task_unit = $_POST['taskUnit'];
                    $task_price = $_POST['price'];
                    if(empty($task_name) || empty($task_unit) || empty($task_price)) {                
                    echo "<script type='text/javascript'>
                    var toastMixin = Swal.mixin({
                        toast: true,
                        icon: 'success',
                        title: 'General Title',
                        animation: false,
                        position: 'top-right',
                        showConfirmButton: false,
                        timer: 5000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    });
                    toastMixin.fire({
                        title: 'Bad entry, Please fill all required fields',
                        icon: 'error'
                    });
                    </script>";
                    die();
                    } else { 
                    $updateTask = "UPDATE tasks SET task_name = '$task_name', task_desc = '$task_desc', unit_id = '$task_unit', price = '$task_price' WHERE id = '$task_id'";
                        if ($db->query($updateTask) === TRUE) {
                            echo "<script type='text/javascript'>
                      var toastMixin = Swal.mixin({
                      toast: true,
                      icon: 'success',
                      title: 'General Title',
                      animation: false,
                      position: 'top-right',
                      showConfirmButton: false,
                      timer: 5000,
                      timerProgressBar: true,
                      didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                      }
                    });
                    toastMixin.fire({
                      animation: true,
                      title: 'Task Updated Successfully'
                    });
                  </script>";
                  die();
                        } else {
                        echo "Error";
                        }}
                    };
                $db->close(); 
            ?>
        </form>
    </section><!-- /.content -->
  </div><!-- /.content-wrapper -->

  <!-- Footer -->
  <?php  include 'footer.php'; //Pages footer ?>