<!DOCTYPE html>
<html lang="en">

<head>
  <style>
    .required:after {
      content:" *";
      color: red;
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Add Task</title>

  <?php
    include 'header.php';
    include 'navbar.php';
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Task Add</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Add Task</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" name="newTaskForm">
        <div class="row">
          <div class="col-md-6">
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">General</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                </div>
              </div>
              <div class="card-body">
                <div class="form-group">
                  <label for="taskName" class="required">Task Name</label>
                  <input type="text" id="taskName" name="taskName" class="form-control">
                </div>
                <div class="form-group">
                  <label for="taskDescription">Task Description</label>
                  <textarea id="taskDescription" name="taskDescription" class="form-control" rows="4"></textarea>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <div class="col-md-6">
            <div class="card card-secondary">
              <div class="card-header">
                <h3 class="card-title">Details</h3>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                    <i class="fas fa-minus"></i>
                  </button>
                </div>
              </div>
              <div class="card-body">
                <div class="form-group">
                  <label for="inputTaskUnit" class="required">Unit Type</label>
                  <select id="taskUnit" name="taskUnit" class="form-control custom-select">
                    <!-- option selected disabled>Select one</!-->
                    <?php
                      $query = $db->query("SELECT * FROM units ORDER BY id ASC");
                      if($query->num_rows > 0){
                        while($row = $query->fetch_assoc()){
                          $unit_name = $row["unit_name"];
                          $unit_id = $row["id"];
                          echo '<option value="'.$unit_id.'">'.$unit_name.'</option>';
                        }
                      };
                      //$db->close();
                    ?>
                  </select>
                </div>
                <div class="form-group">
                  <label for="price" class="required">Price</label>
                  <input type="numebr" id="price" name="price" class="form-control">
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
        </div>
      <div class="row">
        <div class="col-12">
          <a href="tasks.php" class="btn btn-secondary">Back to All Tasks</a>
          <input type="submit" name="submit" value="Add New Task" class="btn btn-success float-right">
        </div>
      </div>
      <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
      <?php
      if(isset($_POST["submit"])) {    
        $task_name = $_POST['taskName'];
        $task_desc = $_POST['taskDescription'];
        $task_unit = $_POST['taskUnit'];
        $task_price = $_POST['price'];
        if(is_numeric($_POST['taskUnit'])){
          $task_unit = $_POST['taskUnit'];
        } else {
          die();
        };
        if(empty($task_name) || empty($task_unit) || empty($task_price)) {                
          echo "<script type='text/javascript'>
          var toastMixin = Swal.mixin({
            toast: true,
            icon: 'success',
            title: 'General Title',
            animation: false,
            position: 'top-right',
            showConfirmButton: false,
            timer: 5000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
          });
          toastMixin.fire({
            title: 'Bad entry, Please fill all required fields',
            icon: 'error'
          });
          </script>";
          die();
        } else { 
                $addTask = "INSERT INTO tasks (task_name, task_desc, unit_id, price) VALUES ('".$task_name."','".$task_desc."','".$task_unit."','".$task_price."')";
                    if ($db->query($addTask) === TRUE) {
                      echo "<script type='text/javascript'>
                      var toastMixin = Swal.mixin({
                      toast: true,
                      icon: 'success',
                      title: 'General Title',
                      animation: false,
                      position: 'top-right',
                      showConfirmButton: false,
                      timer: 5000,
                      timerProgressBar: true,
                      didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                      }
                    });
                    toastMixin.fire({
                      animation: true,
                      title: 'Task Added Successfully'
                    });
                  </script>";
                  die();
    } else {
    //else
    }}};

$db->close(); 
?>
    </fomr>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Footer -->
  <?php
  include 'footer.php'; //Pages footer
  ?>
