<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Projects</title>

  <?php
  include 'header.php';
  include 'navbar.php';
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Projects</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Projects</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="card">
        <div class="card-header">
          <h3 class="card-title">Projects</h3>

          <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
              <i class="fas fa-minus"></i>
            </button>
            <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
              <i class="fas fa-times"></i>
            </button>
          </div>
        </div>
        <div class="card-body p-0">
          <table class="table table-striped projects">
              <thead>
                  <tr>
                      <th style="width: 1%">
                          #
                      </th>
                      <th style="width: 20%">
                          Project Name
                      </th>
                      <th style="width: 30%">
                          Team Leader
                      </th>
                      <th>
                          Project Age
                      </th>
                      <th style="width: 8%" class="text-center">
                          Status
                      </th>
                      <th style="width: 20%">
                      </th>
                  </tr>
              </thead>
              <tbody>
                <?php
                        $query1 = $db->query("SELECT * FROM projects ORDER BY id DESC");
                        $project_desc = "";
                        $currentDate = date('y-m-d', time());
                        if($query1->num_rows > 0){
                        while($row = $query1->fetch_assoc()){
                            $project_id = $row["id"];
                            $project_name = $row["project_name"];
                            $project_desc = $row["project_desc"];
                            $project_lder = $row["project_leader"];
                            $project_sdte = $row["project_start_date"];
                            $project_fdte = $row["project_deadline"];
                            $project_status = $row["project_status"];
                            //$project_age = (strtotime($now) - strtotime($project_fdte)) / (60 * 60 * 24);
                            $project_lif = date_diff(date_create($project_fdte), date_create($project_sdte), true);
                            $project_age = date_diff(date_create($currentDate), date_create($project_fdte), true);
                            $project_finish = 100 - (($project_age->format('%R%a'))/($project_lif->format('%R%a')) * 100);
                            $query2 = $db->query("SELECT * FROM users WHERE id ='".$project_lder."'");
                            if($query2 !== false && $query2->num_rows > 0){
                                while($row = $query2->fetch_assoc()){
                                  $user_name = $row["user_name"];
                                  $user_phne = $row["user_phone"];
                                  $user_imge = $row["user_image"];
                                }
                              };
                            ?>
                  <tr>
                      <td>
                          <?php echo $project_id; ?>
                      </td>
                      <td>
                          <a>
                            <?php echo $project_name; ?>
                          </a>
                          <br/>
                          <small>
                              Created: <?php echo $project_sdte; ?>
                          </small>
                      </td>
                      <td>
                          <ul class="list-inline">
                              <li class="list-inline-item">
                                    <img alt="Avatar" class="table-avatar" src="../uploads/<?php echo $user_imge; ?>">
                              </li>
                              <li class="list-inline-item">
                                    <small><?php echo $user_name; ?></small>
                              </li>
                              <li class="list-inline-item">
                                    <small> - Phone: <?php echo $user_phne; ?></small>
                              </li>
                          </ul>
                      </td>
                      <td class="project_progress">
                          <div class="progress progress-sm">
                          <?php
                            if(($project_finish > 50) && ($project_finish < 80)){
                                echo '<div class="progress-bar bg-warning" role="progressbar" aria-valuenow="'.$project_finish.'" aria-valuemin="0" aria-valuemax="100" style="width:'.$project_finish.'%"></div>';
                            } elseif(($project_finish >= 80) && ($project_finish < 100)) {
                                echo '<div class="progress-bar bg-danger" role="progressbar" aria-valuenow="'.$project_finish.'" aria-valuemin="0" aria-valuemax="100" style="width:'.$project_finish.'%"></div>';
                            } else {
                                echo '<div class="progress-bar bg-success" role="progressbar" aria-valuenow="'.$project_finish.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$project_finish.'%"></div>';
                            };
                          ?>
                              
                          </div>
                          <small>
                            <?php echo round($project_finish); ?>% Passed
                          </small>
                      </td>
                      <td class="project-state">
                          <?php
                            if(($project_finish > 50) && ($project_finish < 80)){
                                echo '<span class="badge badge-warning">Running</span>';
                            } elseif(($project_finish >= 80) && ($project_finish < 100)) {
                                echo '<span class="badge badge-danger">Deadline</span>';
                            } else {
                                echo '<span class="badge badge-success">--Early--</span>';
                            };
                          ?>
                      </td>
                      <td class="project-actions text-right float-right">
                          <div class="row">
                        <form name="projectView" action="project-view.php" method="post">
                            <input name="project_id_view" value='<?php echo $project_id; ?>' hidden>
                            <input type="submit" class="btn btn-success float-right" id="submiew" name="submiew" value="view">
                          </form>
                          <form name="projectEdit" action="project-edit.php" method="post">
                            <input name="project_id_edit" value='<?php echo $project_id; ?>' hidden>
                            <input type="submit" class="btn btn-primary " id="submdit" name="submdit" value="Edit">
                          </form>
                          <?php
                            if($project_finish >= 100){
                                echo '<form name="projectDrop" action="project-drop.php" method="post">
                                <input name="project_id_drop" value="'.$project_id.'" hidden>
                                <input type="submit" class="btn btn-danger " id="submdrp" name="submdrp" value="Drop">
                                </form>';
                            }; ?>
                            </div>
                      </td>
                  </tr>
                  <?php }}; ?>
              </tbody>
          </table>
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

    <!-- Footer -->
    <?php
        include 'footer.php'; //Pages footer
    ?>
