<!DOCTYPE html>
<html lang="en">
<head>
  <style>
    .required:after {
      content:" *";
      color: red;
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Add Project</title>

  <?php
  use Componere\Value;
  include 'header.php';
  include 'navbar.php';
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Project Add</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Project Add</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" name="newProjectForm">
      <div class="row">
        <div class="col-md-6">
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">General</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="projectName" class="required">Project Name</label>
                <input type="text" id="projectName" name="projectName" class="form-control">
              </div>
              <div class="form-group">
                <label for="projectDescription">Project Description</label>
                <textarea id="projectDescription" name="projectDescription" class="form-control" rows="8"></textarea>
              </div>
              <div class="form-group">
                <label for="inputProjectLeader">Project Leader</label>
                <select id="projectLeader" name="projectLeader" class="form-control custom-select">
                  <!-- option selected disabled>Select one</!-->
                  <?php
                    $query = $db->query("SELECT * FROM users ORDER BY id ASC");
                    if($query->num_rows > 0){
                      while($row = $query->fetch_assoc()){
                        $user_name = $row["user_name"];
                        $user_id = $row["id"];
                        echo '<option value="'.$user_id.'">'.$user_name.'</option>';
                      }
                    };
                    //$db->close();
                  ?>
                </select>
              </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <div class="col-md-6">
          <div class="card card-secondary">
            <div class="card-header">
              <h3 class="card-title">Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="projectClient">Client Name</label>
                <input type="text" id="projectClient" name="projectClient" class="form-control">
              </div>
              <div class="form-group">
                <label for="statingDate" class="required">Starting Date</label>
                <input type="date" id="statingDate" name="statingDate" class="form-control" type="date">
              </div>
              <div class="form-group">
                <label for="estimatedDeadline" class="required">Estimated Deadline</label>
                <input type="date" id="estimatedDeadline" name="estimatedDeadline" class="form-control">
              </div>
              <div class="form-group">
                <label for="inputEstimatedDuration">Estimated project duration in days</label>
                <input type="number" id="inputEstimatedDuration" class="form-control" value="1">
              </div>
              <div class="form-group">
                <label for="inputProjectStatus" class="required">Status</label>
                <select name="projectStatus" class="form-control custom-select">
                  <!--option selected disabled>Select one</!--option-->
                  <option value ="1">Running</option>
                  <option value ="2">Canceled</option>
                  <option value ="3">Success</option>
                </select>
              </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <a href="projects.php" class="btn btn-secondary">Back to Projects</a>
          <input type="submit" name="submit" value="Create new Porject" class="btn btn-success float-right">
        </div>
      </div>
      <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
      <?php
      $project_leader = 0;
      $project_status = 0;
      if(isset($_POST["submit"])) {    
        $project_name = $_POST['projectName'];
        $project_description = $_POST['projectDescription'];
        $project_client = $_POST['projectClient'];
        $project_starting_date = $_POST['statingDate'];
        $project_deadline = $_POST['estimatedDeadline'];
        if(is_numeric($_POST['projectLeader'])){
          $project_leader = $_POST['projectLeader'];
        } else {
          $project_leader = 0;
        };
        if(!is_null($_POST['projectStatus'])){
          $project_status = $_POST['projectStatus'];
        } else {
          empty($project_status) == true;
        };
        if(empty($project_name) || empty($project_starting_date) || empty($project_deadline) || empty($project_status)) {                
          echo "<script type='text/javascript'>
          var toastMixin = Swal.mixin({
            toast: true,
            icon: 'success',
            title: 'General Title',
            animation: false,
            position: 'top-right',
            showConfirmButton: false,
            timer: 5000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
          });
          toastMixin.fire({
            title: 'Bad entry, Please fill all required fields',
            icon: 'error'
          });
          </script>";
        } else { 
                    $sql = "INSERT INTO projects (project_name, project_desc, project_leader, project_client, project_start_date, project_deadline, project_status) VALUES ('".$project_name."','".$project_description."','".$project_leader."','".$project_client."','".$project_starting_date."','".$project_deadline."','".$project_status."')";

                    //$statusMsg = '';

                    if ($db->query($sql) === TRUE) {
                      echo "<script type='text/javascript'>
                      var toastMixin = Swal.mixin({
                      toast: true,
                      icon: 'success',
                      title: 'General Title',
                      animation: false,
                      position: 'top-right',
                      showConfirmButton: false,
                      timer: 5000,
                      timerProgressBar: true,
                      didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                      }
                    });
                    toastMixin.fire({
                      animation: true,
                      title: 'Project Added Successfully'
                    });
                  </script>";
                  die();
    } else {
    //else
    }}};

$db->close(); 
?>
    </fomr>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Footer -->
  <?php
  include 'footer.php'; //Pages footer
  ?>
