<!DOCTYPE html>
<html lang="en">
<head>
  <style>
    .required:after {
      content:" *";
      color: red;
    }
  </style>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Add Material</title>

  <?php
  use Componere\Value;
  include 'header.php';
  include 'navbar.php';
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Material Add</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Add Material</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <form action="" method="post" name="newMaterialForm">
      <div class="row">
        <div class="col-md-6">
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">General</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="materialName" class="required">Material Name</label>
                <input type="text" id="materialName" name="materialName" class="form-control">
              </div>
              <div class="form-group">
                <label for="materialDescription">Material Description</label>
                <textarea id="materialDescription" name="materialDescription" class="form-control" rows="8"></textarea>
              </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <div class="col-md-6">
          <div class="card card-secondary">
            <div class="card-header">
              <h3 class="card-title">Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="dateOfPurchase">Date of purchase</label>
                <input type="date" id="dateOfPurchase" class="form-control">
              </div>
              <div class="form-group">
                <label for="inputMaterialStatus" class="required">Unit Type</label>
                <select name="materialStatus" class="form-control custom-select">
                  <!--option selected disabled>Select one</!--option-->
                  <option value ="1">Unit / Piece</option>
                  <option value ="2">Kilogram</option>
                  <option value ="3">Box</option>
                  <option value ="3">Unit</option>
                </select>
              </div>
              <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="quantity" class="required">Quantity</label>
                        <input type="number" id="quantity" name="quantity" class="form-control" value="1">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="minimumQuantity">Minimum Quantity</label>
                        <input type="number" id="minimumQuantity" name="minimumQuantity" class="form-control"  value="1">
                    </div>
                </div>
              </div>
              <div class="form-group">
                <label for="price" class="required">Price</label>
                <input type="numebr" id="price" name="pricw" class="form-control">
              </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <a href="materials.php" class="btn btn-secondary">Cancel</a>
          <input type="submit" name="submit" value="Add New Material" class="btn btn-success float-right">
        </div>
      </div>
      <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
      <?php
      $material_leader = 0;
      $material_status = 0;
      if(isset($_POST["submit"])) {    
        $material_name = $_POST['materialName'];
        $material_descroption = $_POST['materialDescription'];
        $material_client = $_POST['materialClient'];
        $material_starting_date = $_POST['quantity'];
        $material_deadline = $_POST['minimumQuantity'];
        if(is_numeric($_POST['materialLeader'])){
          $material_leader = $_POST['materialLeader'];
        } else {
          $material_leader = 0;
        };
        if(!is_null($_POST['materialStatus'])){
          $material_status = $_POST['materialStatus'];
        } else {
          empty($material_status) == true;
        };
        if(empty($material_name) || empty($material_starting_date) || empty($material_deadline) || empty($material_status)) {                
          echo "<script type='text/javascript'>
          var toastMixin = Swal.mixin({
            toast: true,
            icon: 'success',
            title: 'General Title',
            animation: false,
            position: 'top-right',
            showConfirmButton: false,
            timer: 5000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
          });
          toastMixin.fire({
            title: 'Bad entry, Please fill all required fields',
            icon: 'error'
          });
          </script>";
        } else { 
                    $sql = "INSERT INTO materials (material_name, material_dec, material_leader, material_client, material_start_date, material_deadline, material_status) VALUES ('".$material_name."','".$material_descroption."','".$material_leader."','".$material_client."','".$material_starting_date."','".$material_deadline."','".$material_status."')";

                    //$statusMsg = '';

                    if ($db->query($sql) === TRUE) {
                      echo "<script type='text/javascript'>
                      var toastMixin = Swal.mixin({
                      toast: true,
                      icon: 'success',
                      title: 'General Title',
                      animation: false,
                      position: 'top-right',
                      showConfirmButton: false,
                      timer: 5000,
                      timerProgressBar: true,
                      didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                      }
                    });
                    toastMixin.fire({
                      animation: true,
                      title: 'Material Added Successfully'
                    });
                  </script>";
                  die();
    } else {
    //else
    }}};

$db->close(); 
?>
    </fomr>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- Footer -->
  <?php
  include 'footer.php'; //Pages footer
  ?>
