<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NGE EMS | Users</title>

  <?php
  include 'header.php'; //Pages Head
  include 'navbar.php'; //Main Sidebar Container
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Users</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Users</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <!-- Default box -->
      <div class="card card-solid">
        <div class="card-body pb-0">
          <div class="row d-flex align-items-stretch">
                <?php
                    $query = $db->query("SELECT * FROM users ORDER BY user_name DESC");
                    if($query->num_rows > 0){
                      while($row = $query->fetch_assoc()){
                        $user_name = $row["user_name"];
                        $user_email = $row["user_email"];
                        $user_phone = $row["user_phone"];
                        $user_address = $row["user_address"];
                        $user_role = $row["user_role"];
                        if($user_role == 1) {
                          $user_role = 'Administrator';
                        } else {
                          $user_role = 'User';
                        };
                        $user_image = $row["user_image"];
                        if(empty($user_image)) {
                          $user_image = '../uploads/user.png';
                        } else {
                          $user_image = '../uploads/'.$row["user_image"];
                        };
                ?>
            <div class="col-12 col-sm-6 col-md-4 d-flex align-items-stretch">
              <div class="card bg-light">
                <div class="card-header text-muted border-bottom-0">
                <?php echo $user_role; ?>
                </div>
                <div class="card-body pt-0">
                  <div class="row">
                    <div class="col-7">
                      <h2 class="lead"><b><?php echo $user_name; ?></b></h2>
                      <p class="text-muted text-sm"><b>Email: </b> <?php echo $user_email; ?> </p>
                      <ul class="ml-4 mb-0 fa-ul text-muted">
                        <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span> <?php echo $user_address; ?></li>
                        <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span> <?php echo $user_phone; ?></li>
                      </ul>
                    </div>
                    <div class="col-5 text-center">
                      <img src="<?php echo $user_image; ?>" alt="user-avatar" class="img-circle img-fluid">
                    </div>
                  </div>
                </div>
                <div class="card-footer">
                  <div class="text-right">
                    <a href="profile.php" class="btn btn-sm btn-primary">
                      <i class="fas fa-user"></i> View Profile
                    </a>
                  </div>
                </div>
              </div>
            </div>
              <?php
                }
              };
              $db->close();
              ?>
          </div>
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php
  include 'footer.php'; //Pages footer
  ?>
